/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.test;

import java.util.function.BiPredicate;
import java.util.function.Function;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.test.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

class AssertionsTest {
    AssertionsTest() {
    }

    @Test
    void assertEquals_sameInstance() {
        Object expected;
        Object actual = expected = new Object();
        Assertions.assertEquals(expected, actual);
    }

    @Test
    void assertAllEquals_null_null() {
        Assertions.assertAllEquals(null, null);
    }

    @Test
    void assertAllEquals_Set_List() {
        Assertions.assertAllEquals(Arrays.asSet((Object[])new String[]{"a", "b", "c"}), Arrays.asList((Object[])new String[]{"a", "b", "c"}));
        Assertions.assertAllEquals(Arrays.asHashSet((Object[])new String[]{"b", "c", "a"}), Arrays.asList((Object[])new String[]{"a", "b", "c"}));
        AssertionsTest.assertAssertion(() -> Assertions.assertAllEquals(Arrays.asSet((Object[])new String[]{"b", "c", "a"}), Arrays.asList((Object[])new String[]{"a", "b", "c"})), "expected: <[b, c, a]> but was: <[a, b, c]>");
    }

    @Test
    void assertAllEquals_Set_List_false() {
        AssertionsTest.assertAssertion(() -> Assertions.assertAllEquals(Arrays.asSet((Object[])new String[]{"a", "b", "c"}), Arrays.asList((Object[])new String[]{"1", "2", "3"})), "expected: <[a, b, c]> but was: <[1, 2, 3]>");
        AssertionsTest.assertAssertion(() -> Assertions.assertAllEquals(Arrays.asSet((Object[])new String[]{"a", "b", "c"}), Arrays.asList((Object[])new String[]{"a", "b"})), "expected: <[a, b, c]> but was: <[a, b]>");
    }

    @Test
    void assertEquals_nonNull_null_fails() {
        Object expected = new Object();
        AssertionsTest.assertAssertion(() -> Assertions.assertEquals(expected, null), "expected: <" + expected + "> but was: <null>");
    }

    @Test
    void assertEquals_null_nonNull_fails() {
        Object actual = new Object();
        AssertionsTest.assertAssertion(() -> Assertions.assertEquals(null, actual), "expected: <null> but was: <" + actual + ">");
    }

    @Test
    void assertEquals_inputHasSameToString_failureMssageContainsDistinguishNames() {
        String toStringMessage = "my dummy toString";
        Object expected = new Object(){

            public String toString() {
                return "my dummy toString";
            }
        };
        Object actual = new Object(){

            public String toString() {
                return "my dummy toString";
            }
        };
        AssertionsTest.assertAssertion(() -> Assertions.assertEquals(expected, actual), "expected: " + Assertions.systemToString(expected) + "<" + "my dummy toString" + "> but was: " + Assertions.systemToString(actual) + "<" + "my dummy toString" + ">");
    }

    @Test
    void assertEquals_comparator() {
        Assertions.assertEquals("A", "a", String.CASE_INSENSITIVE_ORDER);
    }

    @Test
    void assertEquals_comparator_failureMessage() {
        AssertionsTest.assertAssertion(() -> Assertions.assertEquals("b", "a", String.CASE_INSENSITIVE_ORDER), "expected: <b> but was: <a>");
    }

    @Test
    void assertEquals_mapper() {
        Assertions.assertEquals("b", "a", s -> 1);
    }

    @Test
    void assertEquals_mapper_failureMessage() {
        AssertionsTest.assertAssertion(() -> Assertions.assertEquals("b", "a", String::toUpperCase), "expected: <B> but was: <A>");
    }

    @Test
    void assertEquals_predicate() {
        Assertions.assertEquals("b", "a", (e, a) -> true);
    }

    @Test
    void assertEquals_predicate_failureMessage() {
        BiPredicate<Object, Object> biPredicate = (e, a) -> false;
        AssertionsTest.assertAssertion(() -> Assertions.assertEquals("b", "a", biPredicate), "expected: <b> but was: <a>");
    }

    @Test
    void assertEquals_mapper_predicate() {
        Assertions.assertEquals("b", "a", String::toUpperCase, (e, a) -> true);
    }

    @Test
    void assertEquals_mapper_predicate_failureMessage() {
        BiPredicate<Object, Object> biPredicate = (e, a) -> false;
        AssertionsTest.assertAssertion(() -> Assertions.assertEquals("b", "a", String::toUpperCase, biPredicate), "expected: <B> but was: <A>");
    }

    @Test
    void assertEquals_iterable_mapper() {
        Assertions.assertAllEquals(Arrays.asList((Object[])new String[]{"a", "b"}), Arrays.asHashSet((Object[])new String[]{"a", "b"}), String::toUpperCase);
    }

    @Test
    void assertEquals_iterable_mapper_failureMessage() {
        AssertionsTest.assertAssertion(() -> Assertions.assertAllEquals(Arrays.asList((Object[])new String[]{"b", "a"}), Arrays.asHashSet((Object[])new String[]{"c", "b"}), String::toUpperCase), "expected: <[B, A]> but was: <[B, C]>");
    }

    @Test
    void systemToString() {
        Object o = new Object();
        Assertions.assertEquals("java.lang.Object@" + Integer.toHexString(System.identityHashCode(o)), Assertions.systemToString(o));
        Assertions.assertEquals("java.lang.String@" + Integer.toHexString(System.identityHashCode("a")), Assertions.systemToString("a"));
    }

    @Test
    void assertAllEquals() {
        Assertions.assertAllEquals(Arrays.asList((Object[])new String[]{"1", "2", "3"}), Arrays.asList((Object[])new Integer[]{1, 2, 3}), Integer::valueOf, Function.identity());
    }

    @Test
    void assertAllEquals_failureMessage() {
        AssertionsTest.assertAssertion(() -> Assertions.assertAllEquals(Arrays.asList((Object[])new String[]{"0", "2", "3"}), Arrays.asList((Object[])new Integer[]{1, 2, 3}), Integer::valueOf, Function.identity()), "expected: <[0, 2, 3]> but was: <[1, 2, 3]>");
    }

    @Test
    void assertAllEquals_predicate() {
        Assertions.assertAllEquals(Arrays.asList((Object[])new String[]{"1", "2", "3"}), Arrays.asList((Object[])new Integer[]{1, 2, 3}), (s, i) -> Integer.valueOf(s).equals(i));
    }

    @Test
    void assertAllEquals_predicate_failureMessage() {
        AssertionsTest.assertAssertion(() -> Assertions.assertAllEquals(Arrays.asList((Object[])new String[]{"0", "2", "3"}), Arrays.asList((Object[])new Integer[]{1, 2, 3}), (s, i) -> Integer.valueOf(s).equals(i)), "expected: <[0, 2, 3]> but was: <[1, 2, 3]>");
    }

    private static void assertAssertion(Runnable assertion, String message) {
        AssertionFailedError thrownException = null;
        try {
            assertion.run();
        }
        catch (AssertionFailedError assertionFailedError) {
            thrownException = assertionFailedError;
        }
        if (thrownException == null) {
            throw new AssertionFailedError("assertion failed");
        }
        if (!message.equals(thrownException.getMessage())) {
            throw new AssertionFailedError("wrong message", (Object)message, (Object)thrownException.getMessage());
        }
    }
}

